package gov.va.med.mhv.admin.repository;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.admin.model.CalendarEvent;

@Repository
public interface CalendarEventRepository extends JpaRepository<CalendarEvent, Long> {

	@Query("select calEvent from CalendarEvent calEvent " + "where calEvent.userProfileId = :userProfileId  "
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getPersonalEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("rangeStart") Date rangeStart, @Param("rangeEnd") Date rangeEnd);

	@Query("select calEvent from CalendarEvent calEvent " + "where calEvent.userProfileId = :userProfileId  and  "
			+ "(upper(subject) LIKE upper(:keyword) or upper(description) LIKE upper(:keyword) or upper(location) LIKE upper(:keyword) ) order by calEvent.startDate desc")
	public List<CalendarEvent> searchPersonalEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("keyword") String keyword);

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.userProfileId = :userProfileId or calEvent.visn.visnId = :visnId or calEvent.vhaEvent = 1) "
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getAllEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("visnId") Long visnId, @Param("rangeStart") Date rangeStart, @Param("rangeEnd") Date rangeEnd);

	// Retrieve National events

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.userProfileId = :userProfileId ) and ( calEvent.vhaEvent is not null or calEvent.vhaEvent = 1) "
			+ "and ( calEvent.visn.visnId is  null or calEvent.visn.visnId = 0)"
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getNationalEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("rangeStart") Date rangeStart, @Param("rangeEnd") Date rangeEnd);

	// Retrieve Regional events

	@Query("select calEvent from CalendarEvent calEvent " + "where (calEvent.userProfileId = :userProfileId ) "
			+ "and ( calEvent.visn.visnId is not null and calEvent.visn.visnId = :usrVisnId)"
			+ "and ( calEvent.vhaEvent is not  null or calEvent.vhaEvent = 0)"
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getRegionalEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("rangeStart") Date rangeStart, @Param("rangeEnd") Date rangeEnd, @Param("usrVisnId") Long usrVisnId);

	// Retrieve Generic events

	@Query("select calEvent from CalendarEvent as calEvent, CalendarCategory as calCat "
			+ "where (calEvent.calendarCategory = calCat.calendarCategoryId)"
			+ "and (calCat.deleted is null or calCat.deleted = 0)" + "and (calCat.categoryName = :allSelEvents)"
			+ "and ( calEvent.vhaEvent=TRUE or (calEvent.visn.visnId != 0 and calEvent.visn.visnId = :usrVisnId))"
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getGenericEventsForUser(@Param("rangeStart") Date rangeStart,
			@Param("rangeEnd") Date rangeEnd, @Param("usrVisnId") Long usrVisnId,
			@Param("allSelEvents") String allSelEvents);
	
	
	
	@Query("select calEvent from CalendarEvent as calEvent, CalendarCategory as calCat "
			+ " where (calEvent.calendarCategory = calCat.calendarCategoryId)"
			+ " and (calCat.deleted is null or calCat.deleted = 0)" + "and (calCat.categoryName = :allSelEvents)"
			+ " and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ " (calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ " (calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ " order by calEvent.startDate desc")
	public List<CalendarEvent> getEventsForAdminUser(@Param("rangeStart") Date rangeStart,
			@Param("rangeEnd") Date rangeEnd, @Param("allSelEvents") String allSelEvents);
	

	@Query("select calEvent from CalendarEvent as calEvent, CalendarCategory as calCat "
			+ "where calEvent.calendarCategory = calCat.calendarCategoryId "
			+ "and (calCat.deleted is null or calCat.deleted = 0 ) " + "and calCat.categoryName = :allSelEvents "
			+ "and ( calEvent.vhaEvent=TRUE or (calEvent.visn.visnId != 0 and calEvent.visn.visnId = :usrVisnId)) "
			+ " and (upper(subject) LIKE upper(:keyword) or upper(description) LIKE upper(:keyword) or upper(location) LIKE upper(:keyword) ) order by calEvent.startDate desc")
	public List<CalendarEvent> searchGenericEventsForUser(@Param("usrVisnId") Long usrVisnId,
			@Param("allSelEvents") String allSelEvents, @Param("keyword") String keyword);
	
	
	@Query("select calEvent from CalendarEvent as calEvent, CalendarCategory as calCat "
			+ " where calEvent.calendarCategory = calCat.calendarCategoryId "
			+ " and (calCat.deleted is null or calCat.deleted = 0 ) " + "and calCat.categoryName = :allSelEvents "
			+ " and (upper(subject) LIKE upper(:keyword) or upper(description) LIKE upper(:keyword) or upper(location) LIKE upper(:keyword) ) order by calEvent.startDate desc")
	public List<CalendarEvent> searchEventsForAdminUser(@Param("allSelEvents") String allSelEvents, @Param("keyword") String keyword);
	

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.visn.visnId is not null or calEvent.vhaEvent = 1) "
			+ "and ((calEvent.startDate between :rangeStart and :rangeEnd and calEvent.recurUntilDate is null and calEvent.repeating = 0) or "
			+ "(calEvent.startDate <= :rangeEnd and calEvent.endDate >= :rangeStart and calEvent.repeating = 1) or "
			+ "(calEvent.recurUntilDate >= :rangeStart and calEvent.startDate <= :rangeEnd)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getAllEventsForAdmin(@Param("rangeStart") Date rangeStart,
			@Param("rangeEnd") Date rangeEnd);

	@Query("SELECT calEvent from CalendarEvent as calEvent, UserCalView as userCalView "
			+ "where (userCalView.visn.visnId = :visnId and calEvent.userProfileId = userCalView.userProfileId and calEvent.visn.visnId is null "
			+ "and calEvent.reminderInterval is not null and calEvent.apiEventKey is null) "
			+ "and ( (calEvent.reminderDate = :reminderDate) or "
			+ "(calEvent.recurUntilDate >= :reminderDate and calEvent.reminderDate <= :reminderDate) " + ") "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getAllPersonalReminderEventsByVisn(@Param("visnId") Long visnId,
			@Param("reminderDate") Date reminderDate);

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.reminderInterval is not null and calEvent.visn.visnId = :visnId and calEvent.vhaEvent is null) "
			+ "and ((calEvent.reminderDate = :reminderDate) or "
			+ "(calEvent.recurUntilDate >= :reminderDate and calEvent.reminderDate <= :reminderDate)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getAllVHAReminderEventsByVisn(@Param("visnId") Long visnId,
			@Param("reminderDate") Date reminderDate);

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.reminderInterval is not null and calEvent.vhaEvent is null) "
			+ "and ((calEvent.reminderDate = :reminderDate) or "
			+ "(calEvent.recurUntilDate >= :reminderDate and calEvent.reminderDate <= :reminderDate)) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> getAllVHAGlobalReminderEvents(@Param("reminderDate") Date reminderDate);

	/*
	 * //TODO: Verify this query. Not sure if the .apiCatId = : apiEventKey.
	 * 
	 * @Query("SELECT calEvent from CalendarEvent as calEvent, UserCalView as userCalView, CalViewApiReminder as apiReminder "
	 * + "where (userCalView.visn.visnId = :visnId " +
	 * "and calEvent.userProfileId = userCalView.userProfileId " +
	 * "and calEvent.apiEventKey = :apiEventKey " +
	 * "and calEvent.vhaEvent is null " +
	 * "and calEvent.reminderInterval is not null " +
	 * "and apiReminder.calViewApiCat.apiCategory.apiCatId = :apiEventKey " +
	 * "and apiReminder.userCalView.userCalViewId = userCalView.userCalViewId) "
	 * + "and " + "( " + "(calEvent.reminderDate = :reminderDate) " + "or " +
	 * "(calEvent.recurUntilDate >= :reminderDate and calEvent.reminderDate <= :reminderDate) "
	 * + ") " + "order by calEvent.startDate desc") public List<CalendarEvent>
	 * getAllAPIReminderEventsByVisn(@Param("visnId") Long
	 * visnId, @Param("reminderDate") Date reminderDate, @Param("apiEventKey")
	 * Long apiEventKey);
	 */
	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.userProfileId = :userProfileId or calEvent.visn.visnId = :visnId or calEvent.vhaEvent = 1) "
			+ "and ((upper(subject) LIKE upper(:keyword)) " + " or (upper(description) LIKE upper(:keyword)) "
			+ " or (upper(location) LIKE upper(:keyword))) " + " order by calEvent.startDate desc ")
	public List<CalendarEvent> findAllEventsForUser(@Param("userProfileId") Long userProfileId,
			@Param("visnId") Long visnId, @Param("keyword") String keyword);

	@Query("select calEvent from CalendarEvent calEvent "
			+ "where (calEvent.visn.visnId is not null or calEvent.vhaEvent = 1) "
			+ "and ((upper(subject) LIKE upper(:keyword)) " + "	or (upper(location) LIKE upper(:keyword))) "
			+ "order by calEvent.startDate desc")
	public List<CalendarEvent> findAllEventsForAdmin(@Param("keyword") String keyword);

}
